
<?php
session_start();
// ডাটাবেস কানেকশন (এক ফোল্ডার পিছে আছে তাই ../ ব্যবহার করা হয়েছে)
require_once '../db_connect.php';

// লগইন চেক
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: index.php");
    exit();
}

// কিছু বেসিক ডাটা আনা (Statistics)
$total_users = $conn->query("SELECT COUNT(*) as count FROM users")->fetch_assoc()['count'];
$total_balance = $conn->query("SELECT SUM(balance) as total FROM users")->fetch_assoc()['total'];
$pending_deposits = $conn->query("SELECT COUNT(*) as count FROM deposits WHERE status='pending'")->fetch_assoc()['count'];
$pending_withdrawals = $conn->query("SELECT COUNT(*) as count FROM withdrawals WHERE status='pending'")->fetch_assoc()['count'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <!-- ফন্ট অসাম -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- অ্যাডমিন স্টাইল -->
    <link rel="stylesheet" href="style.css">
</head>
<body>

    <!-- সাইডবার মেনু -->
    <div class="sidebar">
        <div class="logo">BOT CLUB ADMIN</div>
        <ul>
            <li><a href="dashboard.php" class="active"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
            <li><a href="users.php"><i class="fas fa-users"></i> Manage Users</a></li>
            <li><a href="deposits.php"><i class="fas fa-money-bill-wave"></i> Deposits <span class="badge"><?php echo $pending_deposits; ?></span></a></li>
            <li><a href="withdrawals.php"><i class="fas fa-hand-holding-usd"></i> Withdrawals <span class="badge"><?php echo $pending_withdrawals; ?></span></a></li>
            <li><a href="game_control.php"><i class="fas fa-gamepad"></i> Game Control</a></li>
            <li><a href="settings.php"><i class="fas fa-cogs"></i> Settings</a></li>
            <li><a href="logout.php" style="color: #ff4d4d;"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
        </ul>
    </div>

    <!-- মেইন কন্টেন্ট -->
    <div class="main-content">
        <div class="header">
            <h2>Dashboard Overview</h2>
        </div>

        <!-- কার্ড সেকশন -->
        <div class="cards">
            <div class="card">
                <i class="fas fa-users"></i>
                <h3>Total Users</h3>
                <p><?php echo $total_users; ?></p>
            </div>
            <div class="card">
                <i class="fas fa-wallet"></i>
                <h3>User Balance</h3>
                <p>৳ <?php echo number_format($total_balance, 2); ?></p>
            </div>
            <div class="card warning">
                <i class="fas fa-arrow-down"></i>
                <h3>Pending Deposits</h3>
                <p><?php echo $pending_deposits; ?></p>
            </div>
            <div class="card danger">
                <i class="fas fa-arrow-up"></i>
                <h3>Pending Withdraw</h3>
                <p><?php echo $pending_withdrawals; ?></p>
            </div>
        </div>

        <div class="welcome-box">
            <h3>Welcome Admin!</h3>
            <p>Select an option from the sidebar to manage your website.</p>
        </div>
    </div>

</body>
</html>
